/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.constants.TrustedCaIndicationIdentifierType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.TrustedAuthorityPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrustedCaIndicationExtensionPreparator
extends ExtensionPreparator<TrustedCaIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TrustedCaIndicationExtensionMessage msg;

    public TrustedCaIndicationExtensionPreparator(Chooser chooser, TrustedCaIndicationExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        this.msg.setTrustedAuthorities(this.chooser.getConfig().getTrustedCaIndicationExtensionAuthorities());
        int taLength = 0;
        for (TrustedAuthority ta : this.msg.getTrustedAuthorities()) {
            TrustedAuthorityPreparator preparator = new TrustedAuthorityPreparator(this.chooser, ta);
            preparator.prepare();
            taLength += this.getLength(ta);
        }
        this.msg.setTrustedAuthoritiesLength(taLength);
    }

    public int getLength(TrustedAuthority authority) {
        TrustedCaIndicationIdentifierType type = TrustedCaIndicationIdentifierType.getIdentifierByByte((Byte)authority.getIdentifierType().getValue());
        if (type != null) {
            switch (type) {
                case PRE_AGREED: {
                    return 1;
                }
                case KEY_SHA1_HASH: {
                    return 20;
                }
                case X509_NAME: {
                    return 2 + (Integer)authority.getDistinguishedNameLength().getValue();
                }
                case CERT_SHA1_HASH: {
                    return 20;
                }
            }
            return 0;
        }
        LOGGER.warn("Could not find type. Using 0 length instead");
        return 0;
    }
}

