/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension.quic;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameterEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParametersExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.constants.QuicTransportParameterEntryTypes;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.quic.QuicTransportParametersEntrySerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuicTransportParametersExtensionsPreparator
extends ExtensionPreparator<QuicTransportParametersExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final QuicTransportParametersExtensionMessage msg;

    public QuicTransportParametersExtensionsPreparator(Chooser chooser, QuicTransportParametersExtensionMessage message, ExtensionSerializer<QuicTransportParametersExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        List<QuicTransportParameterEntry> quicTransportEntrys = this.chooser.getConfig().getDefaultQuicTransportParameters().toListOfEntries();
        quicTransportEntrys = new ArrayList<QuicTransportParameterEntry>(quicTransportEntrys);
        quicTransportEntrys.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_SOURCE_CONNECTION_ID, DataConverter.bytesToRawHexString((byte[])this.chooser.getContext().getQuicContext().getSourceConnectionId()).toLowerCase()));
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (QuicTransportParameterEntry parameterEntry : quicTransportEntrys) {
            QuicTransportParametersEntrySerializer serializer = new QuicTransportParametersEntrySerializer(parameterEntry);
            stream.write(serializer.serialize());
        }
        this.msg.setParameterExtensions(stream.toByteArray());
        this.msg.setParameterExtensionsLength(stream.toByteArray().length);
    }
}

