/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.protocol.message.AckMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckSerializer
extends ProtocolMessageSerializer<AckMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AckSerializer(AckMessage message) {
        super(message);
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing AckMessage");
        this.writeRecordNumbersLength();
        this.writeRecordNumbers();
        return this.getAlreadySerialized();
    }

    private void writeRecordNumbersLength() {
        LOGGER.debug("RecordNumberLength: {}", ((AckMessage)this.message).getRecordNumberLength().getValue());
        this.appendInt((Integer)((AckMessage)this.message).getRecordNumberLength().getValue(), 2);
    }

    private void writeRecordNumbers() {
        LOGGER.debug("RecordNumbers: ");
        for (RecordNumber recordNumber : ((AckMessage)this.message).getRecordNumbers()) {
            this.appendBigInteger((BigInteger)recordNumber.getEpoch().getValue(), 8);
            this.appendBigInteger((BigInteger)recordNumber.getSequenceNumber().getValue(), 8);
            LOGGER.debug("\t - {}", (Object)recordNumber);
        }
    }
}

