/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestSerializer
extends HandshakeMessageSerializer<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateRequestMessage msg;
    private final ProtocolVersion version;

    public CertificateRequestSerializer(CertificateRequestMessage message, ProtocolVersion version) {
        super(message);
        this.msg = message;
        this.version = version;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing CertificateRequestMessage");
        if (this.version.is13()) {
            this.writeCertificateRequestContextLength(this.msg);
            this.writeCertificateRequestContext(this.msg);
            this.writeExtensionLength();
            this.writeExtensionBytes();
        } else {
            this.writeClientCertificateTypesCount(this.msg);
            this.writeClientCertificateTypes(this.msg);
            if (this.version == ProtocolVersion.TLS12 || this.version == ProtocolVersion.DTLS12) {
                this.writeSignatureHandshakeAlgorithmsLength(this.msg);
                this.writeSignatureHandshakeAlgorithms(this.msg);
            }
            this.writeDistinguishedNamesLength(this.msg);
            if (this.hasDistinguishedNames(this.msg)) {
                this.writeDistinguishedNames(this.msg);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeClientCertificateTypesCount(CertificateRequestMessage msg) {
        this.appendInt((Integer)msg.getClientCertificateTypesCount().getValue(), 1);
        LOGGER.debug("ClientCertificateTypesCount: {}", msg.getClientCertificateTypesCount().getValue());
    }

    private void writeClientCertificateTypes(CertificateRequestMessage msg) {
        this.appendBytes((byte[])msg.getClientCertificateTypes().getValue());
        LOGGER.debug("ClientCertificateTypes: {}", msg.getClientCertificateTypes().getValue());
    }

    private void writeSignatureHandshakeAlgorithmsLength(CertificateRequestMessage msg) {
        this.appendInt((Integer)msg.getSignatureHashAlgorithmsLength().getValue(), 2);
        LOGGER.debug("SignatureHashAlgorithmsLength: {}", msg.getSignatureHashAlgorithmsLength().getValue());
    }

    private void writeSignatureHandshakeAlgorithms(CertificateRequestMessage msg) {
        this.appendBytes((byte[])msg.getSignatureHashAlgorithms().getValue());
        LOGGER.debug("SignatureHashAlgorithms: {}", msg.getSignatureHashAlgorithms().getValue());
    }

    private void writeDistinguishedNamesLength(CertificateRequestMessage msg) {
        this.appendInt((Integer)msg.getDistinguishedNamesLength().getValue(), 2);
        LOGGER.debug("DistinguishedNamesLength: {}", msg.getDistinguishedNamesLength().getValue());
    }

    private boolean hasDistinguishedNames(CertificateRequestMessage msg) {
        return (Integer)msg.getDistinguishedNamesLength().getValue() != 0;
    }

    private void writeDistinguishedNames(CertificateRequestMessage msg) {
        this.appendBytes((byte[])msg.getDistinguishedNames().getValue());
        LOGGER.debug("DistinguishedNames: {}", msg.getDistinguishedNames().getValue());
    }

    private void writeCertificateRequestContext(CertificateRequestMessage msg) {
        this.appendBytes((byte[])msg.getCertificateRequestContext().getValue());
        LOGGER.debug("CertificateRequestContext: {}", msg.getCertificateRequestContext().getValue());
    }

    private void writeCertificateRequestContextLength(CertificateRequestMessage msg) {
        this.appendInt((Integer)msg.getCertificateRequestContextLength().getValue(), 1);
        LOGGER.debug("CertificateRequestContextLength: {}", msg.getCertificateRequestContextLength().getValue());
    }
}

