/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CoreClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HelloMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CoreClientHelloSerializer<T extends CoreClientHelloMessage>
extends HelloMessageSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;
    private final ProtocolVersion version;

    public CoreClientHelloSerializer(T message, ProtocolVersion version) {
        super(message);
        this.msg = message;
        this.version = version;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing ClientHelloMessage");
        this.writeProtocolVersion();
        this.writeRandom();
        this.writeSessionIDLength();
        this.writeSessionID();
        if (this.version.isDTLS()) {
            this.writeCookieLength(this.msg);
            this.writeCookie(this.msg);
        }
        this.writeCipherSuiteLength(this.msg);
        this.writeCipherSuites(this.msg);
        this.writeCompressionLength(this.msg);
        this.writeCompressions(this.msg);
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength(this.msg);
            if (this.hasExtensions()) {
                this.writeExtensionBytes(this.msg);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeCookieLength(T msg) {
        this.appendInt((Integer)((CoreClientHelloMessage)msg).getCookieLength().getValue(), 1);
        LOGGER.debug("CookieLength: {}", ((CoreClientHelloMessage)msg).getCookieLength().getValue());
    }

    private void writeCookie(T msg) {
        this.appendBytes((byte[])((CoreClientHelloMessage)msg).getCookie().getValue());
        LOGGER.debug("Cookie: {}", ((CoreClientHelloMessage)msg).getCookie().getValue());
    }

    private void writeCipherSuiteLength(T msg) {
        this.appendInt((Integer)((CoreClientHelloMessage)msg).getCipherSuiteLength().getValue(), 2);
        LOGGER.debug("CipherSuiteLength: {}", ((CoreClientHelloMessage)msg).getCipherSuiteLength().getValue());
    }

    private void writeCipherSuites(T msg) {
        this.appendBytes((byte[])((CoreClientHelloMessage)msg).getCipherSuites().getValue());
        LOGGER.debug("CipherSuite: {}", ((CoreClientHelloMessage)msg).getCipherSuites().getValue());
    }

    private void writeCompressionLength(T msg) {
        this.appendInt((Integer)((CoreClientHelloMessage)msg).getCompressionLength().getValue(), 1);
        LOGGER.debug("CompressionLength: {}", ((CoreClientHelloMessage)msg).getCompressionLength().getValue());
    }

    private void writeCompressions(T msg) {
        this.appendBytes((byte[])((CoreClientHelloMessage)msg).getCompressions().getValue());
        LOGGER.debug("Compressions: {}", ((CoreClientHelloMessage)msg).getCompressions().getValue());
    }

    private void writeExtensionLength(T msg) {
        this.appendInt((Integer)((HandshakeMessage)msg).getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionLength: {}", ((HandshakeMessage)msg).getExtensionsLength().getValue());
    }

    private void writeExtensionBytes(T msg) {
        this.appendBytes((byte[])((HandshakeMessage)msg).getExtensionBytes().getValue());
        LOGGER.debug("ExtensionBytes:{} ", ((HandshakeMessage)msg).getExtensionBytes().getValue());
    }
}

