/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangeSerializer<T extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public DHEServerKeyExchangeSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing DHEServerKeyExchangeMessage");
        this.writePLength(this.msg);
        this.writeP(this.msg);
        this.writeGLength(this.msg);
        this.writeG(this.msg);
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.writeSignatureAndHashAlgorithm(this.msg);
        }
        this.writeSignatureLength(this.msg);
        this.writeSignature(this.msg);
        return this.getAlreadySerialized();
    }

    protected byte[] serializeDheParams() {
        this.writePLength(this.msg);
        this.writeP(this.msg);
        this.writeGLength(this.msg);
        this.writeG(this.msg);
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writePLength(T msg) {
        this.appendInt((Integer)((DHEServerKeyExchangeMessage)msg).getModulusLength().getValue(), 2);
        LOGGER.debug("pLength: {}", ((DHEServerKeyExchangeMessage)msg).getModulusLength().getValue());
    }

    private void writeP(T msg) {
        this.appendBytes((byte[])((DHEServerKeyExchangeMessage)msg).getModulus().getValue());
        LOGGER.debug("P: {}", ((DHEServerKeyExchangeMessage)msg).getModulus().getValue());
    }

    private void writeGLength(T msg) {
        this.appendInt((Integer)((DHEServerKeyExchangeMessage)msg).getGeneratorLength().getValue(), 2);
        LOGGER.debug("gLength: {}", ((DHEServerKeyExchangeMessage)msg).getGeneratorLength().getValue());
    }

    private void writeG(T msg) {
        this.appendBytes((byte[])((DHEServerKeyExchangeMessage)msg).getGenerator().getValue());
        LOGGER.debug("G: {}", ((DHEServerKeyExchangeMessage)msg).getGenerator().getValue());
    }

    private void writeSerializedPublicKeyLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 2);
        LOGGER.debug("SerializedPublicKeyLength: {}", ((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: {}", ((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    private void writeSignatureAndHashAlgorithm(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
        LOGGER.debug("SignatureAndHashAlgorithm: {}", ((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
    }

    private void writeSignatureLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getSignatureLength().getValue(), 2);
        LOGGER.debug("SignatureLength: {}", ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }

    private void writeSignature(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue());
        LOGGER.debug("Signature: {}", ((ServerKeyExchangeMessage)msg).getSignature().getValue());
    }
}

