/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangeSerializer<T extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public ECDHClientKeyExchangeSerializer(T message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing ECDHClientKeyExchangeMessage");
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    protected byte[] serializeEcDhParams() {
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSerializedPublicKeyLength(T msg) {
        this.appendInt((Integer)((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 1);
        LOGGER.debug("SerializedPublicKeyLength: {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(T msg) {
        this.appendBytes((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: {}", ((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
    }
}

