/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMessageSerializer
extends ProtocolMessageSerializer<HeartbeatMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HeartbeatMessageSerializer(HeartbeatMessage message) {
        super(message);
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing HeartbeatMessage");
        this.writeHeartbeatMessageType();
        this.writePayloadLength();
        this.writePayload();
        this.writePadding();
        return this.getAlreadySerialized();
    }

    private void writeHeartbeatMessageType() {
        this.appendByte((Byte)((HeartbeatMessage)this.message).getHeartbeatMessageType().getValue());
        LOGGER.debug("HeartbeatMessageType: {}", ((HeartbeatMessage)this.message).getHeartbeatMessageType().getValue());
    }

    private void writePayloadLength() {
        this.appendInt((Integer)((HeartbeatMessage)this.message).getPayloadLength().getValue(), 2);
        LOGGER.debug("PayloadLength: {}", ((HeartbeatMessage)this.message).getPayloadLength().getValue());
    }

    private void writePayload() {
        this.appendBytes((byte[])((HeartbeatMessage)this.message).getPayload().getValue());
        LOGGER.debug("Payload: {}", ((HeartbeatMessage)this.message).getPayload().getValue());
    }

    private void writePadding() {
        this.appendBytes((byte[])((HeartbeatMessage)this.message).getPadding().getValue());
        LOGGER.debug("Padding: {}", ((HeartbeatMessage)this.message).getPadding().getValue());
    }
}

