/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class NewSessionTicketSerializer
extends HandshakeMessageSerializer<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NewSessionTicketMessage msg;
    private ProtocolVersion version;

    public NewSessionTicketSerializer(NewSessionTicketMessage message, ProtocolVersion version) {
        super(message);
        this.msg = message;
        this.version = version;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing NewSessionTicketMessage");
        this.writeLifetimeHint(this.msg);
        if (this.version.is13()) {
            this.writeTicketAgeAdd(this.msg);
            this.writeTicketNonceLength(this.msg);
            this.writeTicketNonce(this.msg);
            this.writeTicketIdentityLength(this.msg);
            this.writeTicketIdentity(this.msg);
            this.writeExtensions();
        } else {
            this.writeTicketLength(this.msg);
            this.writeTicket(this.msg);
        }
        return this.getAlreadySerialized();
    }

    private void writeLifetimeHint(NewSessionTicketMessage msg) {
        this.appendBytes(DataConverter.longToBytes((long)((Long)msg.getTicketLifetimeHint().getValue()), (int)4));
        LOGGER.debug("LifetimeHint: {}", new Supplier[]{() -> DataConverter.longToBytes((long)((Long)msg.getTicketLifetimeHint().getValue()), (int)4)});
    }

    private void writeTicketLength(NewSessionTicketMessage msg) {
        this.appendBytes(DataConverter.intToBytes((int)((Integer)msg.getTicket().getIdentityLength().getValue()), (int)2));
        LOGGER.debug("TicketLength: {}", new Supplier[]{() -> DataConverter.intToBytes((int)((Integer)msg.getTicket().getIdentityLength().getValue()), (int)2)});
    }

    private void writeTicket(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getIdentity().getValue());
        LOGGER.debug("Ticket: {}", msg.getTicket().getIdentity().getValue());
    }

    private void writeTicketAgeAdd(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getTicketAgeAdd().getValue());
        LOGGER.debug("TicketAgeAdd: {}", msg.getTicket().getTicketAgeAdd().getValue());
    }

    private void writeTicketNonceLength(NewSessionTicketMessage msg) {
        this.appendBytes(DataConverter.intToBytes((int)((Integer)msg.getTicket().getTicketNonceLength().getValue()), (int)1));
        LOGGER.debug("TicketNonceLength: {}", msg.getTicket().getTicketNonceLength().getValue());
    }

    private void writeTicketNonce(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getTicketNonce().getValue());
        LOGGER.debug("TicketNonce: {}", msg.getTicket().getTicketNonce().getValue());
    }

    private void writeTicketIdentityLength(NewSessionTicketMessage msg) {
        this.appendBytes(DataConverter.intToBytes((int)((Integer)msg.getTicket().getIdentityLength().getValue()), (int)2));
        LOGGER.debug("TicketIdentityLength: {}", msg.getTicket().getIdentityLength().getValue());
    }

    private void writeTicketIdentity(NewSessionTicketMessage msg) {
        this.appendBytes((byte[])msg.getTicket().getIdentity().getValue());
        LOGGER.debug("TicketIdentity: {}", msg.getTicket().getIdentity().getValue());
    }

    private void writeExtensions() {
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength();
            if (this.hasExtensions()) {
                this.writeExtensionBytes();
            }
        }
    }
}

