/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClientKeyExchangeSerializer
extends ClientKeyExchangeSerializer<PWDClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDClientKeyExchangeMessage msg;

    public PWDClientKeyExchangeSerializer(PWDClientKeyExchangeMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PWDClientKeyExchangeMessage");
        this.writeElementLength(this.msg);
        this.writeElement(this.msg);
        this.writeScalarLength(this.msg);
        this.writeScalar(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeElementLength(PWDClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getElementLength().getValue(), 1);
        LOGGER.debug("ElementLength: {}", msg.getElementLength().getValue());
    }

    private void writeElement(PWDClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getElement().getValue());
        LOGGER.debug("Element: {}", msg.getElement().getValue());
    }

    private void writeScalarLength(PWDClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getScalarLength().getValue(), 1);
        LOGGER.debug("ScalarLength: {}", msg.getScalarLength().getValue());
    }

    private void writeScalar(PWDClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getScalar().getValue());
        LOGGER.debug("Scalar: {}", msg.getScalar().getValue());
    }
}

