/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDServerKeyExchangeSerializer
extends ServerKeyExchangeSerializer<PWDServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDServerKeyExchangeMessage msg;

    public PWDServerKeyExchangeSerializer(PWDServerKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PWDServerKeyExchangeMessage");
        this.writeSaltLength(this.msg);
        this.writeSalt(this.msg);
        this.writeCurveType(this.msg);
        this.writeNamedGroup(this.msg);
        this.writeElementLength(this.msg);
        this.writeElement(this.msg);
        this.writeScalarLength(this.msg);
        this.writeScalar(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSaltLength(PWDServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getSaltLength().getValue(), 1);
        LOGGER.debug("SaltLength: {}", msg.getSaltLength().getValue());
    }

    private void writeSalt(PWDServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getSalt().getValue());
        LOGGER.debug("Salt: {}", msg.getSalt().getValue());
    }

    private void writeCurveType(PWDServerKeyExchangeMessage msg) {
        this.appendByte((Byte)msg.getGroupType().getValue());
        LOGGER.debug("CurveType: {}", msg.getGroupType().getValue());
    }

    private void writeNamedGroup(PWDServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getNamedGroup().getValue());
        LOGGER.debug("NamedGroup: {}", msg.getNamedGroup().getValue());
    }

    private void writeElementLength(PWDServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getElementLength().getValue(), 1);
        LOGGER.debug("ElementLength: {}", msg.getElementLength().getValue());
    }

    private void writeElement(PWDServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getElement().getValue());
        LOGGER.debug("Element: {}", msg.getElement().getValue());
    }

    private void writeScalarLength(PWDServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getScalarLength().getValue(), 1);
        LOGGER.debug("ScalarLength: {}", msg.getScalarLength().getValue());
    }

    private void writeScalar(PWDServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getScalar().getValue());
        LOGGER.debug("Scalar: {}", msg.getScalar().getValue());
    }
}

