/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ECDHEServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDheServerKeyExchangeSerializer
extends ECDHEServerKeyExchangeSerializer<PskEcDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskEcDheServerKeyExchangeMessage msg;

    public PskEcDheServerKeyExchangeSerializer(PskEcDheServerKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKECDHEServerKeyExchangeMessage");
        this.writePSKIdentityHintLength(this.msg);
        this.writePSKIdentityHint(this.msg);
        super.serializeEcDheParams();
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityHintLength(PskEcDheServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityHintLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityLength: {}", msg.getIdentityHintLength().getValue());
    }

    private void writePSKIdentityHint(PskEcDheServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentityHint().getValue());
        LOGGER.debug("SerializedPSKIdentity: {}", msg.getIdentityHint().getValue());
    }
}

