/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.RSAClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskRsaClientKeyExchangeSerializer
extends RSAClientKeyExchangeSerializer<PskRsaClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskRsaClientKeyExchangeMessage msg;

    public PskRsaClientKeyExchangeSerializer(PskRsaClientKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKRSAClientKeyExchangeMessage");
        this.writePSKIdentityLength(this.msg);
        this.writePSKIdentity(this.msg);
        super.serializeRsaParams();
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityLength(PskRsaClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityLength: {}", msg.getIdentityLength().getValue());
    }

    private void writePSKIdentity(PskRsaClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentity().getValue());
        LOGGER.debug("SerializedPSKIdentity: {}", msg.getIdentity().getValue());
    }
}

