/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2MessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientMasterKeySerializer
extends SSL2MessageSerializer<SSL2ClientMasterKeyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ClientMasterKeySerializer(SSL2ClientMasterKeyMessage message) {
        super(message);
    }

    @Override
    public byte[] serializeMessageContent() {
        LOGGER.debug("Serializing SSL2ClientMasterKey");
        this.writeCipherKind();
        this.writeClearKeyLength();
        this.writeEncryptedKeyLength();
        this.writeKeyArgLength();
        this.writeClearKeyData();
        this.writeEncryptedKeyData();
        this.writeKeyArgData();
        return this.getAlreadySerialized();
    }

    private void writeEncryptedKeyData() {
        byte[] encryptedKeyData = (byte[])((SSL2ClientMasterKeyMessage)this.message).getEncryptedKeyData().getValue();
        this.appendBytes(encryptedKeyData);
        LOGGER.debug("EncryptedKey: {}", (Object)encryptedKeyData);
    }

    private void writeClearKeyData() {
        byte[] clearKeyData = (byte[])((SSL2ClientMasterKeyMessage)this.message).getClearKeyData().getValue();
        this.appendBytes(clearKeyData);
        LOGGER.debug("ClearKey: {}", (Object)clearKeyData);
    }

    private void writeEncryptedKeyLength() {
        int length = (Integer)((SSL2ClientMasterKeyMessage)this.message).getEncryptedKeyLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("EncryptedKeyLength: {}", (Object)length);
    }

    public void writeKeyArgData() {
        byte[] keyArgData = (byte[])((SSL2ClientMasterKeyMessage)this.message).getKeyArgData().getValue();
        this.appendBytes(keyArgData);
        LOGGER.debug("KeyArg: {}", (Object)keyArgData);
    }

    private void writeKeyArgLength() {
        int length = (Integer)((SSL2ClientMasterKeyMessage)this.message).getKeyArgLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("EncryptedKeyLength: {}", (Object)length);
    }

    private void writeClearKeyLength() {
        int length = (Integer)((SSL2ClientMasterKeyMessage)this.message).getClearKeyLength().getValue();
        this.appendInt(length, 2);
        LOGGER.debug("ClearKeyLength: {}", (Object)length);
    }

    private void writeCipherKind() {
        byte[] cipherKindValue = (byte[])((SSL2ClientMasterKeyMessage)this.message).getCipherKind().getValue();
        this.appendBytes(cipherKindValue);
        LOGGER.debug("CipherKind: {}", (Object)cipherKindValue);
    }
}

