/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SSL2MessageSerializer<T extends SSL2Message>
extends Serializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T message;

    public SSL2MessageSerializer(T ssl2HandshakeMessage) {
        this.message = ssl2HandshakeMessage;
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeMessageLength();
        this.writeType();
        return this.serializeMessageContent();
    }

    protected abstract byte[] serializeMessageContent();

    private void writeMessageLength() {
        if ((Integer)((SSL2Message)this.message).getPaddingLength().getValue() != 0) {
            throw new UnsupportedOperationException("Long record headers are not supported");
        }
        this.appendInt((int)((Integer)((SSL2Message)this.message).getMessageLength().getValue() ^ 0x8000), 2);
        LOGGER.debug("MessageLength: {}", ((SSL2Message)this.message).getMessageLength().getValue());
    }

    protected void writeType() {
        this.appendByte((Byte)((SSL2Message)this.message).getType().getValue());
        LOGGER.debug("Type: {}", ((SSL2Message)this.message).getType().getValue());
    }
}

