/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2MessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloSerializer
extends SSL2MessageSerializer<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloSerializer(SSL2ServerHelloMessage message) {
        super(message);
    }

    @Override
    public byte[] serializeMessageContent() {
        LOGGER.debug("Serialize SSL2ServerHello");
        this.writeSessionIdHit();
        this.writeCertificateType();
        this.writeProtocolVersion();
        this.writeCertificateLength();
        this.writeCipherSuitesLength();
        this.writeSessionIDLength();
        this.writeCertificate();
        this.writeCipherSuites();
        this.writeSessionID();
        return this.getAlreadySerialized();
    }

    private void writeSessionIdHit() {
        this.appendByte((Byte)((SSL2ServerHelloMessage)this.message).getSessionIdHit().getValue());
        LOGGER.debug("SessionIdHit: {}", ((SSL2ServerHelloMessage)this.message).getSessionIdHit().getValue());
    }

    private void writeCertificateType() {
        this.appendByte((Byte)((SSL2ServerHelloMessage)this.message).getCertificateType().getValue());
        LOGGER.debug("CertificateType: {}", ((SSL2ServerHelloMessage)this.message).getCertificateType().getValue());
    }

    private void writeProtocolVersion() {
        this.appendBytes((byte[])((SSL2ServerHelloMessage)this.message).getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", ((SSL2ServerHelloMessage)this.message).getProtocolVersion().getValue());
    }

    private void writeCertificateLength() {
        this.appendInt((Integer)((SSL2ServerHelloMessage)this.message).getCertificateLength().getValue(), 2);
        LOGGER.debug("CertificateLength: {}", ((SSL2ServerHelloMessage)this.message).getCertificateLength().getValue());
    }

    private void writeCipherSuitesLength() {
        this.appendInt((Integer)((SSL2ServerHelloMessage)this.message).getCipherSuitesLength().getValue(), 2);
        LOGGER.debug("CipherSuitesLength: {}", ((SSL2ServerHelloMessage)this.message).getCipherSuitesLength().getValue());
    }

    private void writeSessionIDLength() {
        this.appendInt((Integer)((SSL2ServerHelloMessage)this.message).getSessionIdLength().getValue(), 2);
        LOGGER.debug("SessionIDLength: {}", ((SSL2ServerHelloMessage)this.message).getSessionIdLength().getValue());
    }

    private void writeCertificate() {
        this.appendBytes((byte[])((SSL2ServerHelloMessage)this.message).getCertificate().getValue());
        LOGGER.debug("Certificate: {}", ((SSL2ServerHelloMessage)this.message).getCertificate().getValue());
    }

    private void writeCipherSuites() {
        this.appendBytes((byte[])((SSL2ServerHelloMessage)this.message).getCipherSuites().getValue());
        LOGGER.debug("CipherSuites: {}", ((SSL2ServerHelloMessage)this.message).getCipherSuites().getValue());
    }

    private void writeSessionID() {
        this.appendBytes((byte[])((SSL2ServerHelloMessage)this.message).getSessionId().getValue());
        LOGGER.debug("SessionID: {}", ((SSL2ServerHelloMessage)this.message).getSessionId().getValue());
    }
}

