/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HelloMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHelloSerializer
extends HelloMessageSerializer<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerHelloMessage msg;

    public ServerHelloSerializer(ServerHelloMessage message) {
        super(message);
        this.msg = message;
    }

    protected void writeSelectedCipherSuite() {
        this.appendBytes((byte[])this.msg.getSelectedCipherSuite().getValue());
        LOGGER.debug("SelectedCipherSuite: {}", this.msg.getSelectedCipherSuite().getValue());
    }

    protected void writeSelectedCompressionMethod() {
        this.appendByte((Byte)this.msg.getSelectedCompressionMethod().getValue());
        LOGGER.debug("SelectedCompressionMethod: {}", this.msg.getSelectedCompressionMethod().getValue());
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing ServerHelloMessage");
        this.writeProtocolVersion();
        this.writeRandom();
        this.writeSessionIDLength();
        this.writeSessionID();
        this.writeSelectedCipherSuite();
        this.writeSelectedCompressionMethod();
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength();
            if (this.hasExtensions()) {
                this.writeExtensionBytes();
            }
        }
        return this.getAlreadySerialized();
    }
}

