/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.cert;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificatePairSerializer
extends Serializer<CertificateEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateEntry pair;
    private final ProtocolVersion version;

    public CertificatePairSerializer(CertificateEntry pair, ProtocolVersion version) {
        this.pair = pair;
        this.version = version;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing CertificatePair");
        this.writeCertificateLength(this.pair);
        this.writeCertificateBytes(this.pair);
        if (this.version.is13()) {
            this.writeExtensionsLength(this.pair);
            if (this.pair.getExtensionBytes() != null && this.pair.getExtensionBytes().getValue() != null) {
                this.writeExtensionBytes(this.pair);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeCertificateLength(CertificateEntry pair) {
        this.appendInt((Integer)pair.getCertificateLength().getValue(), 3);
        LOGGER.debug("CertificateLength: {}", pair.getCertificateLength().getValue());
    }

    private void writeCertificateBytes(CertificateEntry pair) {
        this.appendBytes((byte[])pair.getCertificateBytes().getValue());
        LOGGER.debug("Certificate: {}", pair.getCertificateBytes().getValue());
    }

    private void writeExtensionsLength(CertificateEntry pair) {
        this.appendInt((Integer)pair.getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionsLength: {}", pair.getExtensionsLength().getValue());
    }

    private void writeExtensionBytes(CertificateEntry pair) {
        this.appendBytes((byte[])pair.getExtensionBytes().getValue());
        LOGGER.debug("Extensions: {}", pair.getExtensionBytes().getValue());
    }
}

