/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.CookieExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CookieExtensionSerializer
extends ExtensionSerializer<CookieExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CookieExtensionMessage msg;

    public CookieExtensionSerializer(CookieExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing CookieExtensionMessage");
        this.serializeCookieLength(this.msg);
        this.serializeCookie(this.msg);
        return this.getAlreadySerialized();
    }

    private void serializeCookieLength(CookieExtensionMessage msg) {
        this.appendInt((Integer)msg.getCookieLength().getValue(), 2);
        LOGGER.debug("Cookie length: {}", msg.getCookieLength().getValue());
    }

    private void serializeCookie(CookieExtensionMessage msg) {
        this.appendBytes((byte[])msg.getCookie().getValue());
        LOGGER.debug("Cookie: {}", msg.getCookie().getValue());
    }
}

