/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.DebugExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugExtensionSerializer
extends ExtensionSerializer<DebugExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DebugExtensionMessage message;

    public DebugExtensionSerializer(DebugExtensionMessage message) {
        super(message);
        this.message = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing DebugExtensionMessage");
        this.serializeDebugContent(this.message);
        return this.getAlreadySerialized();
    }

    private void serializeDebugContent(DebugExtensionMessage msg) {
        this.appendBytes(((String)msg.getDebugContent().getValue()).getBytes(StandardCharsets.ISO_8859_1));
        LOGGER.debug("Debug Message as bytes: {}", (Object)((String)msg.getDebugContent().getValue()).getBytes(StandardCharsets.ISO_8859_1));
        LOGGER.debug("Debug Message as string: {}", msg.getDebugContent().getValue());
    }
}

