/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyDerivationFunction;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ech.HpkeCipherSuite;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedClientHelloExtensionSerializer
extends ExtensionSerializer<EncryptedClientHelloExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EncryptedClientHelloExtensionMessage msg;

    public EncryptedClientHelloExtensionSerializer(EncryptedClientHelloExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        switch (this.msg.getEchClientHelloType()) {
            case INNER: {
                this.writeEchClientHelloType(this.msg);
                if (this.msg.getAcceptConfirmation() == null) break;
                this.writeAcceptConfirmation(this.msg);
                break;
            }
            case OUTER: {
                this.writeEchClientHelloType(this.msg);
                this.writeHpkeCipherSuite(this.msg);
                this.writeConfigId(this.msg);
                this.writeEncLen(this.msg);
                this.writeEnc(this.msg);
                this.writePayloadLen(this.msg);
                this.writePayload(this.msg);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeEchClientHelloType(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes(msg.getEchClientHelloType().getByteValue());
        LOGGER.debug("Write EchClientHelloType: {}", (Object)msg.getEchClientHelloType().getByteValue());
    }

    private void writeHpkeCipherSuite(EncryptedClientHelloExtensionMessage msg) {
        HpkeCipherSuite cipherSuite = msg.getHpkeCipherSuite();
        HpkeAeadFunction aeadFunction = cipherSuite.getAeadFunction();
        HpkeKeyDerivationFunction keyDerivationFunction = cipherSuite.getKeyDerivationFunction();
        this.appendBytes(keyDerivationFunction.getByteValue());
        this.appendBytes(aeadFunction.getByteValue());
        LOGGER.debug("HPKE Ciphersuite: {}", (Object)DataConverter.concatenate((byte[][])new byte[][]{keyDerivationFunction.getByteValue(), aeadFunction.getByteValue()}));
    }

    private void writeConfigId(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes(msg.getConfigId().getByteArray(1));
        LOGGER.debug("Config Id: {}", (Object)msg.getConfigId().getByteArray(1));
    }

    private void writeEncLen(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes(msg.getEncLength().getByteArray(2));
        LOGGER.debug("Enc Length: {}", (Object)msg.getEncLength().getByteArray(2));
    }

    private void writeEnc(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes((byte[])msg.getEnc().getValue());
        LOGGER.debug("Enc: {}", msg.getEnc().getValue());
    }

    private void writePayloadLen(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes(msg.getPayloadLength().getByteArray(2));
        LOGGER.debug("Payload Length: {}", (Object)msg.getPayloadLength().getByteArray(2));
    }

    private void writePayload(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes((byte[])msg.getPayload().getValue());
        LOGGER.debug("Payload: {}", msg.getPayload().getValue());
    }

    private void writeAcceptConfirmation(EncryptedClientHelloExtensionMessage msg) {
        this.appendBytes((byte[])msg.getAcceptConfirmation().getValue());
        LOGGER.debug("Accept Confirmation: {}", msg.getAcceptConfirmation().getValue());
    }
}

