/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionSerializer<T extends ExtensionMessage>
extends Serializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExtensionMessage msg;

    public ExtensionSerializer(T message) {
        this.msg = message;
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeType();
        this.writeLength();
        this.writeContent();
        return this.getAlreadySerialized();
    }

    private void writeType() {
        this.appendBytes((byte[])this.msg.getExtensionType().getValue());
        LOGGER.debug("ExtensionType: {}", this.msg.getExtensionType().getValue());
    }

    private void writeLength() {
        this.appendInt((Integer)this.msg.getExtensionLength().getValue(), 2);
        LOGGER.debug("extensionLength: {}", this.msg.getExtensionLength().getValue());
    }

    private void writeContent() {
        this.appendBytes((byte[])this.msg.getExtensionContent().getValue());
        LOGGER.debug("ExtensionContent: {}", this.msg.getExtensionContent().getValue());
    }

    public abstract byte[] serializeExtensionContent();
}

