/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareEntrySerializer
extends Serializer<KeyShareEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final KeyShareEntry entry;

    public KeyShareEntrySerializer(KeyShareEntry entry) {
        this.entry = entry;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing KeySharePair");
        this.writeKeyShareType(this.entry);
        this.writeKeyShareLength(this.entry);
        this.writeKeyShare(this.entry);
        return this.getAlreadySerialized();
    }

    private void writeKeyShareType(KeyShareEntry pair) {
        this.appendBytes((byte[])pair.getGroup().getValue());
        LOGGER.debug("KeyShareType: {}", pair.getGroup().getValue());
    }

    private void writeKeyShareLength(KeyShareEntry pair) {
        this.appendInt((Integer)pair.getPublicKeyLength().getValue(), 2);
        LOGGER.debug("KeyShareLength: {}", pair.getPublicKeyLength().getValue());
    }

    private void writeKeyShare(KeyShareEntry entry) {
        this.appendBytes((byte[])entry.getPublicKey().getValue());
        LOGGER.debug("KeyShare: {}", entry.getPublicKey().getValue());
    }
}

