/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionSerializer
extends ExtensionSerializer<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final KeyShareExtensionMessage msg;
    private final ConnectionEndType connection;

    public KeyShareExtensionSerializer(KeyShareExtensionMessage message, ConnectionEndType connection) {
        super(message);
        this.msg = message;
        this.connection = connection;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing KeyShareExtensionMessage");
        if (this.connection == ConnectionEndType.CLIENT && this.msg.getKeyShareListLength() != null) {
            this.writeKeyShareListLength(this.msg);
        }
        this.writeKeyShareListBytes(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeKeyShareListLength(KeyShareExtensionMessage msg) {
        this.appendInt((Integer)msg.getKeyShareListLength().getValue(), 2);
        LOGGER.debug("KeyShareListLength: {}", msg.getKeyShareListLength().getValue());
    }

    private void writeKeyShareListBytes(KeyShareExtensionMessage msg) {
        this.appendBytes((byte[])msg.getKeyShareListBytes().getValue());
        LOGGER.debug("KeyShareListBytes: {}", msg.getKeyShareListBytes().getValue());
    }
}

