/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDProtectExtensionSerializer
extends ExtensionSerializer<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDProtectExtensionMessage msg;

    public PWDProtectExtensionSerializer(PWDProtectExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing PWDProtectExtensionMessage");
        this.writeUsernameLength(this.msg);
        this.writeUsername(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeUsernameLength(PWDProtectExtensionMessage msg) {
        this.appendInt((Integer)msg.getUsernameLength().getValue(), 1);
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }

    private void writeUsername(PWDProtectExtensionMessage msg) {
        this.appendBytes((byte[])msg.getUsername().getValue());
        LOGGER.debug("Username: {}", (Object)msg.getUsername());
    }
}

