/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import java.util.HashMap;
import java.util.Map;

public enum QuicFrameType {
    UNKNOWN(Long.MAX_VALUE),
    PADDING_FRAME(0L),
    PING_FRAME(1L),
    ACK_FRAME(2L),
    ACK_FRAME_WITH_ECN(3L),
    RESET_STREAM_FRAME(4L),
    STOP_SENDING_FRAME(5L),
    CRYPTO_FRAME(6L),
    NEW_TOKEN_FRAME(7L),
    STREAM_FRAME(8L),
    STREAM_FRAME_FIN(9L),
    STREAM_FRAME_LEN(10L),
    STREAM_FRAME_LEN_FIN(11L),
    STREAM_FRAME_OFF(12L),
    STREAM_FRAME_OFF_FIN(13L),
    STREAM_FRAME_OFF_LEN(14L),
    STREAM_FRAME_OFF_LEN_FIN(15L),
    MAX_DATA_FRAME(16L),
    MAX_STREAM_DATA_FRAME(17L),
    MAX_STREAMS_BIDI_FRAME(18L),
    MAX_STREAMS_UNI_FRAME(19L),
    DATA_BLOCKED_FRAME(20L),
    STREAM_DATA_BLOCKED_FRAME(21L),
    STREAMS_BLOCKED_BIDI_FRAME(22L),
    STREAMS_BLOCKED_UNI_FRAME(23L),
    NEW_CONNECTION_ID_FRAME(24L),
    RETIRE_CONNECTION_ID(25L),
    PATH_CHALLENGE_FRAME(26L),
    PATH_RESPONSE_FRAME(27L),
    CONNECTION_CLOSE_QUIC_FRAME(28L),
    CONNECTION_CLOSE_APPLICATION_FRAME(29L),
    HANDSHAKE_DONE_FRAME(30L),
    DATAGRAM_FRAME(48L),
    DATAGRAM_FRAME_LEN(49L);

    private final long value;
    private static final Map<Long, QuicFrameType> MAP;

    private QuicFrameType(long value) {
        this.value = value;
    }

    private QuicFrameType() {
        this.value = -1L;
    }

    public static QuicFrameType getFrameType(long value) {
        return MAP.getOrDefault(value, UNKNOWN);
    }

    public long getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    static {
        MAP = new HashMap<Long, QuicFrameType>();
        for (QuicFrameType type : QuicFrameType.values()) {
            if (type == UNKNOWN) continue;
            MAP.put(type.value, type);
        }
    }
}

