/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum QuicPacketType {
    UNKNOWN(255, 255),
    INITIAL_PACKET(192, 208),
    ZERO_RTT_PACKET(208, 224),
    HANDSHAKE_PACKET(224, 240),
    RETRY_PACKET(240, 192),
    ONE_RTT_PACKET(64, 64),
    VERSION_NEGOTIATION(192, 192),
    STATELESS_RESET(254, 254);

    private static final Map<Byte, QuicPacketType> QUIC1_MAP;
    private static final Map<Byte, QuicPacketType> QUIC2_MAP;
    private final byte headerQuic1;
    private final byte headerQuic2;

    private QuicPacketType(int headerQuic1, int headerQuic2) {
        this.headerQuic1 = (byte)headerQuic1;
        this.headerQuic2 = (byte)headerQuic2;
    }

    public static QuicPacketType getPacketTypeFromFirstByte(QuicVersion version, int firstByte) {
        if (version == QuicVersion.NULL_VERSION) {
            return VERSION_NEGOTIATION;
        }
        if (version != QuicVersion.VERSION_1 && version != QuicVersion.VERSION_2) {
            return UNKNOWN;
        }
        if (QuicPacketType.isShortHeaderPacket(firstByte)) {
            return ONE_RTT_PACKET;
        }
        QuicPacketType type = QuicPacketType.getHeaderMap(version).get((byte)(firstByte & 0xF0 | 0x40));
        return Objects.requireNonNullElse(type, UNKNOWN);
    }

    public static boolean isLongHeaderPacket(int firstByte) {
        return !QuicPacketType.isShortHeaderPacket(firstByte);
    }

    public static boolean isShortHeaderPacket(int firstByte) {
        return (firstByte & 0x80) == 0;
    }

    public boolean isFrameContainer() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2, 3, 5 -> true;
            case 0, 4, 6, 7 -> false;
        };
    }

    public byte getHeader(QuicVersion version) {
        return switch (version) {
            case QuicVersion.VERSION_1 -> this.headerQuic1;
            case QuicVersion.VERSION_2 -> this.headerQuic2;
            default -> throw new UnsupportedOperationException();
        };
    }

    private static Map<Byte, QuicPacketType> getHeaderMap(QuicVersion version) {
        return switch (version) {
            case QuicVersion.VERSION_1 -> QUIC1_MAP;
            case QuicVersion.VERSION_2 -> QUIC2_MAP;
            default -> throw new UnsupportedOperationException();
        };
    }

    public String getName() {
        return this.name();
    }

    static {
        QUIC1_MAP = new HashMap<Byte, QuicPacketType>();
        QUIC2_MAP = new HashMap<Byte, QuicPacketType>();
        for (QuicPacketType type : QuicPacketType.values()) {
            if (type == UNKNOWN || type == VERSION_NEGOTIATION || type == STATELESS_RESET) continue;
            QUIC1_MAP.put(type.headerQuic1, type);
            QUIC2_MAP.put(type.headerQuic2, type);
        }
    }
}

