/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;

public class QuicRetryConstants {
    private static final byte[] QUIC1_RETRY_INTEGRITY_TAG_KEY = DataConverter.hexStringToByteArray((String)"be0c690b9f66575a1d766b54e368c84e");
    private static final byte[] QUIC2_RETRY_INTEGRITY_TAG_KEY = DataConverter.hexStringToByteArray((String)"8fb4b01b56ac48e260fbcbcead7ccc92");
    private static final byte[] QUIC1_RETRY_INTEGRITY_TAG_IV = DataConverter.hexStringToByteArray((String)"461599d35d632bf2239825bb");
    private static final byte[] QUIC2_RETRY_INTEGRITY_TAG_IV = DataConverter.hexStringToByteArray((String)"d86969bc2d7c6d9990efb04a");

    public static byte[] getRetryIntegrityTagKey(QuicVersion version) {
        return switch (version) {
            case QuicVersion.VERSION_1 -> QUIC1_RETRY_INTEGRITY_TAG_KEY;
            case QuicVersion.VERSION_2 -> QUIC2_RETRY_INTEGRITY_TAG_KEY;
            default -> throw new UnsupportedOperationException();
        };
    }

    public static byte[] getRetryIntegrityTagIv(QuicVersion version) {
        return switch (version) {
            case QuicVersion.VERSION_1 -> QUIC1_RETRY_INTEGRITY_TAG_IV;
            case QuicVersion.VERSION_2 -> QUIC2_RETRY_INTEGRITY_TAG_IV;
            default -> throw new UnsupportedOperationException();
        };
    }
}

