/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import java.util.HashMap;
import java.util.Map;

public enum QuicTransportErrorCodes {
    NO_ERROR(0),
    INTERNAL_ERROR(1),
    CONNECTION_REFUSED(2),
    FLOW_CONTROL_ERROR(3),
    STREAM_LIMIT_ERROR(4),
    STREAM_STATE_ERROR(5),
    FINAL_SIZE_ERROR(6),
    FRAME_ENCODING_ERROR(7),
    TRANSPORT_PARAMETER_ERROR(8),
    CONNECTION_ID_LIMIT_ERROR(9),
    PROTOCOL_VIOLATION(10),
    INVALID_TOKEN(11),
    APPLICATION_ERROR(12),
    CRYPTO_BUFFER_EXCEEDED(13),
    KEY_UPDATE_ERROR(14),
    AEAD_LIMIT_REACHED(15),
    NO_VIABLE_PATH(16),
    CRYPTO_ERROR(0);

    private final int value;
    private static final Map<Byte, QuicTransportErrorCodes> MAP;

    private QuicTransportErrorCodes(byte value) {
        this.value = value;
    }

    public static QuicTransportErrorCodes getErrorCode(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return (byte)this.value;
    }

    public String getName() {
        return this.name();
    }

    static {
        MAP = new HashMap<Byte, QuicTransportErrorCodes>();
        for (QuicTransportErrorCodes code : QuicTransportErrorCodes.values()) {
            MAP.put((byte)code.value, code);
        }
    }
}

