/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public enum QuicVersion {
    VERSION_1(1, "38762cf7f55934b34d179ae6a4c80cadccbb7f0a"),
    VERSION_2(1798521807, "0dede3def700a6db819381be6e269dcbf9bd2ed9"),
    NEGOTIATION_VERSION(0xA0A0A0A, "38762cf7f55934b34d179ae6a4c80cadccbb7f0a"),
    NULL_VERSION(0, ""),
    UNKNOWN(-1, "");

    private final int value;
    private final byte[] byteValue;
    private final byte[] initialSalt;
    private static final Map<Integer, QuicVersion> MAP;

    private QuicVersion(int value, String initialSalt) {
        this.value = value;
        this.byteValue = ByteBuffer.allocate(4).putInt(value).array();
        this.initialSalt = DataConverter.hexStringToByteArray((String)initialSalt);
    }

    public static QuicVersion getFromVersionBytes(byte[] versionBytes) {
        int versionValue = DataConverter.bytesToInt((byte[])versionBytes);
        return MAP.getOrDefault(versionValue, UNKNOWN);
    }

    public static String getVersionNameFromBytes(byte[] versionBytes) {
        int versionValue = DataConverter.bytesToInt((byte[])versionBytes);
        QuicVersion version = MAP.get(versionValue);
        if (version != null) {
            return version.getName();
        }
        if (versionValue >= 1362112512 && versionValue <= 1362116607) {
            return "GOOGLE_QUIC_" + new String(versionBytes, StandardCharsets.UTF_8);
        }
        if (versionValue >= 1412444160 && versionValue <= 1412448255) {
            return "GOOGLE_QUIC_TLS_" + new String(versionBytes, StandardCharsets.UTF_8);
        }
        if (versionValue >= 1544552448 && versionValue <= 1544552463) {
            return "QUIC_OVER_SCION";
        }
        if (versionValue >= 1363627776 && versionValue <= 1363628031) {
            return "QGO_" + versionBytes[3];
        }
        if (versionValue >= -1849593856 && versionValue <= -1849593601) {
            return "QUICLY0_" + versionBytes[3];
        }
        if (versionValue >= -1412628480 && versionValue <= -1412628465) {
            return "MSQUIC";
        }
        if (versionValue >= -249302848 && versionValue <= -249302833) {
            return "MOZQUIC";
        }
        if (versionValue >= -87117824 && versionValue <= -87117809) {
            return "MVFST";
        }
        if (versionValue >= 0x7007000 && versionValue <= 0x700700F) {
            return "TENCENTQUIC";
        }
        if (versionValue >= 1162299136 && versionValue <= 1162299391) {
            return "QUANT";
        }
        if (versionValue == 1346588976) {
            return "PICOQUIC";
        }
        if (versionValue == 1347571544) {
            return "GOOGLE_QUIC_PROX";
        }
        return "UNKNOWN";
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public byte[] getInitialSalt() {
        return this.initialSalt;
    }

    public String getKeyLabel() {
        return switch (this.ordinal()) {
            case 0 -> "quic key";
            case 1 -> "quicv2 key";
            default -> throw new UnsupportedOperationException();
        };
    }

    public String getIvLabel() {
        return switch (this.ordinal()) {
            case 0 -> "quic iv";
            case 1 -> "quicv2 iv";
            default -> throw new UnsupportedOperationException();
        };
    }

    public String getHeaderProtectionLabel() {
        return switch (this.ordinal()) {
            case 0 -> "quic hp";
            case 1 -> "quicv2 hp";
            default -> throw new UnsupportedOperationException();
        };
    }

    public String getKeyUpdateLabel() {
        return switch (this.ordinal()) {
            case 0 -> "quic ku";
            case 1 -> "quicv2 ku";
            default -> throw new UnsupportedOperationException();
        };
    }

    public String getName() {
        return this.name();
    }

    static {
        MAP = new HashMap<Integer, QuicVersion>();
        for (QuicVersion cm : QuicVersion.values()) {
            MAP.put(cm.getValue(), cm);
        }
    }
}

