/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.longint.ModifiableLong;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.AckFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.AckFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.AckFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.AckFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public class AckFrame
extends QuicFrame {
    @ModifiableVariableProperty
    protected ModifiableLong largestAcknowledged;
    @ModifiableVariableProperty
    protected ModifiableLong ackDelay;
    @ModifiableVariableProperty
    protected ModifiableLong ackRangeCount;
    @ModifiableVariableProperty
    protected ModifiableLong firstACKRange;
    @ModifiableVariableProperty
    protected ModifiableLong ect0;
    @ModifiableVariableProperty
    protected ModifiableLong ect1;
    @ModifiableVariableProperty
    protected ModifiableLong ecnCe;
    private long largestAcknowledgedConfig;
    private long ackDelayConfig;
    private long ackRangeCountConfig;
    private long firstACKRangeConfig;
    private long ect0Config;
    private long ect1Config;
    private long ecnCeConfig;

    private AckFrame() {
    }

    public AckFrame(boolean withECN) {
        if (withECN) {
            this.setFrameType(QuicFrameType.ACK_FRAME_WITH_ECN);
        } else {
            this.setFrameType(QuicFrameType.ACK_FRAME);
        }
        this.ackEliciting = false;
    }

    @Override
    public AckFrameHandler getHandler(Context context) {
        return new AckFrameHandler(context.getQuicContext());
    }

    @Override
    public AckFrameSerializer getSerializer(Context context) {
        return new AckFrameSerializer(this);
    }

    @Override
    public AckFramePreparator getPreparator(Context context) {
        return new AckFramePreparator(context.getChooser(), this);
    }

    @Override
    public AckFrameParser getParser(Context context, InputStream stream) {
        return new AckFrameParser(stream);
    }

    public void setLargestAcknowledged(ModifiableLong largestAcknowledged) {
        this.largestAcknowledged = largestAcknowledged;
    }

    public void setLargestAcknowledged(int largestAcknowledged) {
        this.largestAcknowledged = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.largestAcknowledged, (Long)Long.valueOf(largestAcknowledged));
    }

    public void setLargestAcknowledged(long largestAcknowledged) {
        this.largestAcknowledged = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.largestAcknowledged, (Long)largestAcknowledged);
    }

    public ModifiableLong getLargestAcknowledged() {
        return this.largestAcknowledged;
    }

    public void setAckDelay(ModifiableLong ackDelay) {
        this.ackDelay = ackDelay;
    }

    public void setAckDelay(long ackDelay) {
        this.ackDelay = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ackDelay, (Long)ackDelay);
    }

    public void setAckDelay(int ackDelay) {
        this.ackDelay = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ackDelay, (Long)Long.valueOf(ackDelay));
    }

    public ModifiableLong getAckDelay() {
        return this.ackDelay;
    }

    public void setAckRangeCount(ModifiableLong ackRangeCount) {
        this.ackRangeCount = ackRangeCount;
    }

    public void setAckRangeCount(long ackRangeCount) {
        this.ackRangeCount = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ackRangeCount, (Long)ackRangeCount);
    }

    public void setAckRangeCount(int ackRangeCount) {
        this.ackRangeCount = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ackRangeCount, (Long)Long.valueOf(ackRangeCount));
    }

    public ModifiableLong getAckRangeCount() {
        return this.ackRangeCount;
    }

    public void setFirstACKRange(ModifiableLong firstACKRange) {
        this.firstACKRange = firstACKRange;
    }

    public void setFirstACKRange(long firstACKRange) {
        this.firstACKRange = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.firstACKRange, (Long)firstACKRange);
    }

    public void setFirstACKRange(int firstACKRange) {
        this.firstACKRange = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.firstACKRange, (Long)Long.valueOf(firstACKRange));
    }

    public ModifiableLong getFirstACKRange() {
        return this.firstACKRange;
    }

    public ModifiableLong getEct0() {
        return this.ect0;
    }

    public void setEct0(ModifiableLong ect0) {
        this.ect0 = ect0;
    }

    public void setEct0(long ect0) {
        this.ect0 = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ect0, (Long)ect0);
    }

    public void setEct0(int ect0) {
        this.ect0 = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ect0, (Long)Long.valueOf(ect0));
    }

    public ModifiableLong getEct1() {
        return this.ect1;
    }

    public void setEct1(ModifiableLong ect1) {
        this.ect1 = ect1;
    }

    public void setEct1(long ect1) {
        this.ect1 = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ect1, (Long)ect1);
    }

    public void setEct1(int ect1) {
        this.ect1 = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ect1, (Long)Long.valueOf(ect1));
    }

    public ModifiableLong getEcnCe() {
        return this.ecnCe;
    }

    public void setEcnCe(ModifiableLong ecnCe) {
        this.ecnCe = ecnCe;
    }

    public void setEcnCe(long ecnCe) {
        this.ecnCe = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ecnCe, (Long)ecnCe);
    }

    public void setEcnCe(int ecnCe) {
        this.ecnCe = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ecnCe, (Long)Long.valueOf(ecnCe));
    }

    public long getLargestAcknowledgedConfig() {
        return this.largestAcknowledgedConfig;
    }

    public void setLargestAcknowledgedConfig(long largestAcknowledgedConfig) {
        this.largestAcknowledgedConfig = largestAcknowledgedConfig;
    }

    public long getAckDelayConfig() {
        return this.ackDelayConfig;
    }

    public void setAckDelayConfig(long ackDelayConfig) {
        this.ackDelayConfig = ackDelayConfig;
    }

    public long getAckRangeCountConfig() {
        return this.ackRangeCountConfig;
    }

    public void setAckRangeCountConfig(long ackRangeCountConfig) {
        this.ackRangeCountConfig = ackRangeCountConfig;
    }

    public long getFirstACKRangeConfig() {
        return this.firstACKRangeConfig;
    }

    public void setFirstACKRangeConfig(long firstACKRangeConfig) {
        this.firstACKRangeConfig = firstACKRangeConfig;
    }

    public long getEct0Config() {
        return this.ect0Config;
    }

    public void setEct0Config(long ect0Config) {
        this.ect0Config = ect0Config;
    }

    public long getEct1Config() {
        return this.ect1Config;
    }

    public void setEct1Config(long ect1Config) {
        this.ect1Config = ect1Config;
    }

    public long getEcnCeConfig() {
        return this.ecnCeConfig;
    }

    public void setEcnCeConfig(long ecnCeConfig) {
        this.ecnCeConfig = ecnCeConfig;
    }
}

