/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.longint.ModifiableLong;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicTransportErrorCodes;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.ConnectionCloseFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.ConnectionCloseFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.ConnectionCloseFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.ConnectionCloseFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

@XmlRootElement
public class ConnectionCloseFrame
extends QuicFrame {
    @ModifiableVariableProperty
    private ModifiableLong errorCode;
    @ModifiableVariableProperty
    private ModifiableLong triggerFrameType;
    @ModifiableVariableProperty
    private ModifiableLong reasonPhraseLength;
    @ModifiableVariableProperty
    private ModifiableByteArray reasonPhrase;
    private long errorCodeConfig;
    private long triggerFrameTypeConfig;
    private long reasonPhraseLengthConfig;
    private byte[] reasonPhraseConfig;

    private ConnectionCloseFrame() {
    }

    public ConnectionCloseFrame(boolean isQuicLayer) {
        if (isQuicLayer) {
            this.setFrameType(QuicFrameType.CONNECTION_CLOSE_QUIC_FRAME);
        } else {
            this.setFrameType(QuicFrameType.CONNECTION_CLOSE_APPLICATION_FRAME);
        }
        this.ackEliciting = false;
    }

    public ConnectionCloseFrame(long errorCodeConfig) {
        this(true);
        this.errorCodeConfig = errorCodeConfig;
    }

    public ConnectionCloseFrame(int errorCodeConfig, String reasonPhraseConfig) {
        this(errorCodeConfig);
        this.reasonPhraseConfig = reasonPhraseConfig.getBytes(StandardCharsets.UTF_8);
        this.reasonPhraseLengthConfig = this.reasonPhraseConfig.length;
    }

    public ConnectionCloseFrame(int errorCodeConfig, long triggerFrameTypeConfig, String reasonPhraseConfig) {
        this(errorCodeConfig);
        this.reasonPhraseConfig = reasonPhraseConfig.getBytes(StandardCharsets.UTF_8);
        this.reasonPhraseLengthConfig = this.reasonPhraseConfig.length;
        this.triggerFrameTypeConfig = triggerFrameTypeConfig;
    }

    @Override
    public ConnectionCloseFrameHandler getHandler(Context context) {
        return new ConnectionCloseFrameHandler(context.getQuicContext());
    }

    @Override
    public ConnectionCloseFrameSerializer getSerializer(Context context) {
        return new ConnectionCloseFrameSerializer(this);
    }

    @Override
    public ConnectionCloseFramePreparator getPreparator(Context context) {
        return new ConnectionCloseFramePreparator(context.getChooser(), this);
    }

    @Override
    public ConnectionCloseFrameParser getParser(Context context, InputStream stream) {
        return new ConnectionCloseFrameParser(stream);
    }

    public ModifiableLong getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.errorCode, (Long)errorCode);
    }

    public void setErrorCode(int errorCode) {
        this.setErrorCode((long)errorCode);
    }

    public ModifiableLong getTriggerFrameType() {
        return this.triggerFrameType;
    }

    public void setTriggerFrameType(long triggerFrameType) {
        this.triggerFrameType = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.triggerFrameType, (Long)triggerFrameType);
    }

    public void setTriggerFrameType(int triggerFrameType) {
        this.setTriggerFrameType((long)triggerFrameType);
    }

    public ModifiableLong getReasonPhraseLength() {
        return this.reasonPhraseLength;
    }

    public void setReasonPhraseLength(long reasonPhraseLength) {
        this.reasonPhraseLength = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.reasonPhraseLength, (Long)reasonPhraseLength);
    }

    public void setReasonPhraseLength(int reasonPhraseLength) {
        this.setReasonPhraseLength((long)reasonPhraseLength);
    }

    public ModifiableByteArray getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setReasonPhrase(byte[] reasonPhrase) {
        this.reasonPhrase = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.reasonPhrase, (byte[])reasonPhrase);
    }

    public long getErrorCodeConfig() {
        return this.errorCodeConfig;
    }

    public void setErrorCodeConfig(long errorCodeConfig) {
        this.errorCodeConfig = errorCodeConfig;
    }

    public long getTriggerFrameTypeConfig() {
        return this.triggerFrameTypeConfig;
    }

    public void setTriggerFrameTypeConfig(long triggerFrameTypeConfig) {
        this.triggerFrameTypeConfig = triggerFrameTypeConfig;
    }

    public long getReasonPhraseLengthConfig() {
        return this.reasonPhraseLengthConfig;
    }

    public void setReasonPhraseLengthConfig(long reasonPhraseLengthConfig) {
        this.reasonPhraseLengthConfig = reasonPhraseLengthConfig;
    }

    public byte[] getReasonPhraseConfig() {
        return this.reasonPhraseConfig;
    }

    public void setReasonPhraseConfig(byte[] reasonPhraseConfig) {
        this.reasonPhraseConfig = reasonPhraseConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionCloseFrame:");
        sb.append("\n  errorCode: ");
        if (this.errorCode != null && this.errorCode.getValue() != null) {
            if ((Long)this.errorCode.getValue() > 256L && (Long)this.errorCode.getValue() < 511L) {
                sb.append("CRYPTO_ERROR (").append(this.errorCode.getValue()).append(") -> TLS Alert Description: ").append(AlertDescription.getAlertDescription((byte)((Long)this.errorCode.getValue() & 0xFFL)).name());
            } else {
                QuicTransportErrorCodes transportErrorCode = QuicTransportErrorCodes.getErrorCode(((Long)this.errorCode.getValue()).byteValue());
                if (transportErrorCode != null) {
                    sb.append(transportErrorCode.getName());
                } else {
                    sb.append(this.errorCode.getValue());
                }
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  triggerFrameType: ");
        if (this.triggerFrameType != null && this.triggerFrameType.getValue() != null) {
            if ((Long)this.triggerFrameType.getValue() == 0L) {
                sb.append("unknown");
            } else {
                sb.append((Object)QuicFrameType.getFrameType((Long)this.triggerFrameType.getValue()));
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  reasonPhrase: ");
        if (this.reasonPhrase != null && this.reasonPhrase.getValue() != null) {
            sb.append(new String((byte[])this.reasonPhrase.getValue(), StandardCharsets.UTF_8));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

