/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.longint.ModifiableLong;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.handler.frame.QuicFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.QuicFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public abstract class QuicFrame
extends ModifiableVariableHolder
implements DataContainer {
    protected boolean ackEliciting = true;
    @ModifiableVariableProperty
    private ModifiableLong frameType;

    public QuicFrame() {
    }

    public QuicFrame(QuicFrameType quicFrameType) {
        this.setFrameType(quicFrameType.getValue());
    }

    public void setFrameType(QuicFrameType frameType) {
        this.frameType = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.frameType, (Long)frameType.getValue());
    }

    public void setFrameType(ModifiableLong frameType) {
        this.frameType = frameType;
    }

    public void setFrameType(long frameType) {
        this.frameType = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.frameType, (Long)frameType);
    }

    public ModifiableLong getFrameType() {
        return this.frameType;
    }

    public boolean isAckEliciting() {
        return this.ackEliciting;
    }

    @Override
    public String toCompactString() {
        if (this.frameType == null) {
            return "";
        }
        return QuicFrameType.getFrameType((Long)this.frameType.getValue()).getName();
    }

    public abstract QuicFrameHandler getHandler(Context var1);

    public abstract QuicFrameSerializer getSerializer(Context var1);

    public abstract QuicFramePreparator getPreparator(Context var1);

    public abstract QuicFrameParser getParser(Context var1, InputStream var2);
}

