/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.StreamsBlockedFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.StreamsBlockedFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.StreamsBlockedFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.StreamsBlockedFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public class StreamsBlockedFrame
extends QuicFrame {
    @ModifiableVariableProperty
    protected ModifiableInteger maximumStreams;
    private int maximumStreamsConfig;

    private StreamsBlockedFrame() {
    }

    public StreamsBlockedFrame(boolean isBidirectional) {
        if (isBidirectional) {
            this.setFrameType(QuicFrameType.STREAMS_BLOCKED_BIDI_FRAME);
        } else {
            this.setFrameType(QuicFrameType.STREAMS_BLOCKED_UNI_FRAME);
        }
    }

    public StreamsBlockedFrame(boolean isBidirectional, int maximumStreamsConfig) {
        this(isBidirectional);
        this.maximumStreamsConfig = maximumStreamsConfig;
    }

    @Override
    public StreamsBlockedFrameHandler getHandler(Context context) {
        return new StreamsBlockedFrameHandler(context.getQuicContext());
    }

    @Override
    public StreamsBlockedFrameSerializer getSerializer(Context context) {
        return new StreamsBlockedFrameSerializer(this);
    }

    @Override
    public StreamsBlockedFramePreparator getPreparator(Context context) {
        return new StreamsBlockedFramePreparator(context.getChooser(), this);
    }

    @Override
    public StreamsBlockedFrameParser getParser(Context context, InputStream stream) {
        return new StreamsBlockedFrameParser(stream);
    }

    public ModifiableInteger getMaximumStreams() {
        return this.maximumStreams;
    }

    public void setMaximumStreams(ModifiableInteger maximumStreams) {
        this.maximumStreams = maximumStreams;
    }

    public void setMaximumStreams(int maximumStreams) {
        this.maximumStreams = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.maximumStreams, (Integer)maximumStreams);
    }

    public int getMaximumStreamsConfig() {
        return this.maximumStreamsConfig;
    }

    public void setMaximumStreamsConfig(int maximumStreamsConfig) {
        this.maximumStreamsConfig = maximumStreamsConfig;
    }
}

