/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.handler.packet;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.quic.handler.packet.QuicPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.OneRTTPacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneRTTPacketHandler
extends QuicPacketHandler<OneRTTPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public OneRTTPacketHandler(QuicContext quicContext) {
        super(quicContext);
    }

    @Override
    public void adjustContext(OneRTTPacket packet) {
        try {
            if (!this.quicContext.isApplicationSecretsInitialized()) {
                QuicPacketCryptoComputations.calculateApplicationSecrets(this.quicContext.getContext());
            }
        }
        catch (CryptoException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOGGER.error("Could not calculate application secrets", e);
        }
    }
}

