/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.handler.packet;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.quic.handler.packet.LongHeaderPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.quic.packet.ZeroRTTPacket;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZeroRTTPacketHandler
extends LongHeaderPacketHandler<ZeroRTTPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ZeroRTTPacketHandler(QuicContext quicContext) {
        super(quicContext);
    }

    @Override
    public void adjustContext(ZeroRTTPacket packet) {
        if (!this.quicContext.getConfig().isEchoQuic().booleanValue()) {
            this.quicContext.setDestinationConnectionId((byte[])packet.getSourceConnectionId().getValue());
        }
        try {
            if (!this.quicContext.isZeroRTTSecretsInitialized()) {
                QuicPacketCryptoComputations.calculateZeroRTTSecrets(this.quicContext.getContext());
            }
        }
        catch (CryptoException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOGGER.error("Could not calculate 0-RTT secrets", e);
        }
    }
}

