/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.tlsattacker.core.quic.constants.QuicCryptoSecrets;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.handler.packet.HandshakePacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.HandshakePacketParser;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.HandshakePacketPreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.HandshakePacketSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class HandshakePacket
extends LongHeaderPacket {
    private static final Logger LOGGER = LogManager.getLogger();

    public HandshakePacket() {
        super(QuicPacketType.HANDSHAKE_PACKET);
        this.packetSecret = QuicCryptoSecrets.HANDSHAKE_SECRET;
    }

    public HandshakePacket(byte flags, byte[] versionBytes) {
        super(QuicPacketType.HANDSHAKE_PACKET);
        this.setProtectedFlags(flags);
        this.protectedHeaderHelper.write((int)flags);
        this.packetSecret = QuicCryptoSecrets.HANDSHAKE_SECRET;
        this.setQuicVersion(versionBytes);
        this.protectedHeaderHelper.write(versionBytes);
    }

    public HandshakePacketHandler getHandler(Context context) {
        return new HandshakePacketHandler(context.getQuicContext());
    }

    public HandshakePacketSerializer getSerializer(Context context) {
        return new HandshakePacketSerializer(this);
    }

    public HandshakePacketPreparator getPreparator(Context context) {
        return new HandshakePacketPreparator(context.getChooser(), this);
    }

    public HandshakePacketParser getParser(Context context, InputStream stream) {
        return new HandshakePacketParser(stream, context.getQuicContext());
    }
}

