/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import de.rub.nds.tlsattacker.core.quic.packet.HandshakePacket;
import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.quic.packet.RetryPacket;
import de.rub.nds.tlsattacker.core.quic.packet.VersionNegotiationPacket;
import de.rub.nds.tlsattacker.core.quic.packet.ZeroRTTPacket;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={LongHeaderPacket.class, InitialPacket.class, HandshakePacket.class, VersionNegotiationPacket.class, RetryPacket.class, ZeroRTTPacket.class})
public abstract class LongHeaderPacket
extends QuicPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    protected ModifiableByteArray quicVersion;
    @ModifiableVariableProperty
    protected ModifiableByte sourceConnectionIdLength;
    @ModifiableVariableProperty
    protected ModifiableByteArray sourceConnectionId;

    public LongHeaderPacket(QuicPacketType packetType) {
        super(packetType);
    }

    @Override
    public void buildUnprotectedPacketHeader() {
        this.offsetToPacketNumber = 0;
        this.unprotectedHeaderHelper.reset();
        this.unprotectedHeaderHelper.write((int)((Byte)this.unprotectedFlags.getValue()).byteValue());
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.quicVersion.getValue());
        this.offsetToPacketNumber += ((byte[])this.quicVersion.getValue()).length;
        this.unprotectedHeaderHelper.write((int)((byte)((byte[])this.destinationConnectionId.getValue()).length));
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.destinationConnectionId.getValue());
        this.offsetToPacketNumber += ((Byte)this.destinationConnectionIdLength.getValue()).byteValue();
        this.unprotectedHeaderHelper.write((int)((byte)((byte[])this.sourceConnectionId.getValue()).length));
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.sourceConnectionId.getValue());
        this.offsetToPacketNumber += ((Byte)this.sourceConnectionIdLength.getValue()).byteValue();
        byte[] packetLengthBytes = VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)this.packetLength.getValue()).intValue());
        this.unprotectedHeaderHelper.write(packetLengthBytes);
        this.offsetToPacketNumber += packetLengthBytes.length;
        this.unprotectedHeaderHelper.writeBytes((byte[])this.getUnprotectedPacketNumber().getValue());
        this.offsetToPacketNumber += ((byte[])this.getUnprotectedPacketNumber().getValue()).length;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])this.unprotectedHeaderHelper.toByteArray());
    }

    @Override
    public void convertCompleteProtectedHeader() {
        byte[] protectedHeaderBytes = this.protectedHeaderHelper.toByteArray();
        protectedHeaderBytes[0] = (Byte)this.unprotectedFlags.getValue();
        this.offsetToPacketNumber = 6 + ((byte[])this.destinationConnectionId.getValue()).length + 1 + ((byte[])this.sourceConnectionId.getValue()).length + this.packetLengthSize;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])protectedHeaderBytes);
    }

    public void setSourceConnectionId(ModifiableByteArray sourceConnectionId) {
        this.sourceConnectionId = sourceConnectionId;
    }

    public void setSourceConnectionId(byte[] sourceConnectionId) {
        this.sourceConnectionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.sourceConnectionId, (byte[])sourceConnectionId);
    }

    public void setSourceConnectionIdLength(ModifiableByte sourceConnectionIdLength) {
        this.sourceConnectionIdLength = sourceConnectionIdLength;
    }

    public void setSourceConnectionIdLength(byte variableLengthInteger) {
        this.sourceConnectionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.sourceConnectionIdLength, (Byte)variableLengthInteger);
    }

    public void setQuicVersion(ModifiableByteArray quicVersion) {
        this.quicVersion = quicVersion;
    }

    public void setQuicVersion(byte[] quicVersion) {
        this.quicVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.quicVersion, (byte[])quicVersion);
    }

    public void setQuicVersion(QuicVersion quicVersion) {
        this.setQuicVersion(quicVersion.getByteValue());
    }

    public ModifiableByteArray getSourceConnectionId() {
        return this.sourceConnectionId;
    }

    public ModifiableByte getSourceConnectionIdLength() {
        return this.sourceConnectionIdLength;
    }

    public ModifiableByteArray getQuicVersion() {
        return this.quicVersion;
    }
}

