/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.quic.constants.QuicCryptoSecrets;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.handler.packet.OneRTTPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.OneRTTPacketParser;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.OneRTTPacketPreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.OneRTTPacketSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class OneRTTPacket
extends QuicPacket {
    private static final Logger LOGGER = LogManager.getLogger();

    public OneRTTPacket() {
        super(QuicPacketType.ONE_RTT_PACKET);
        this.packetSecret = QuicCryptoSecrets.APPLICATION_SECRET;
    }

    public OneRTTPacket(byte flags) {
        super(QuicPacketType.ONE_RTT_PACKET);
        this.setProtectedFlags(flags);
        this.protectedHeaderHelper.write((int)flags);
        this.packetSecret = QuicCryptoSecrets.APPLICATION_SECRET;
    }

    @Override
    public void buildUnprotectedPacketHeader() {
        this.offsetToPacketNumber = 0;
        this.unprotectedHeaderHelper.reset();
        this.unprotectedHeaderHelper.write((int)((Byte)this.unprotectedFlags.getValue()).byteValue());
        ++this.offsetToPacketNumber;
        this.unprotectedHeaderHelper.write((byte[])this.destinationConnectionId.getValue());
        this.offsetToPacketNumber += ((Byte)this.destinationConnectionIdLength.getValue()).byteValue();
        this.unprotectedHeaderHelper.writeBytes((byte[])this.getUnprotectedPacketNumber().getValue());
        this.offsetToPacketNumber += ((byte[])this.getUnprotectedPacketNumber().getValue()).length;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])this.unprotectedHeaderHelper.toByteArray());
    }

    @Override
    public void convertCompleteProtectedHeader() {
        byte[] protectedHeaderBytes = this.protectedHeaderHelper.toByteArray();
        protectedHeaderBytes[0] = (Byte)this.unprotectedFlags.getValue();
        this.offsetToPacketNumber = 1 + ((byte[])this.destinationConnectionId.getValue()).length;
        this.completeUnprotectedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeUnprotectedHeader, (byte[])protectedHeaderBytes);
    }

    public OneRTTPacketHandler getHandler(Context context) {
        return new OneRTTPacketHandler(context.getQuicContext());
    }

    public OneRTTPacketSerializer getSerializer(Context context) {
        return new OneRTTPacketSerializer(this);
    }

    public OneRTTPacketPreparator getPreparator(Context context) {
        return new OneRTTPacketPreparator(context.getChooser(), this);
    }

    public OneRTTPacketParser getParser(Context context, InputStream stream) {
        return new OneRTTPacketParser(stream, context.getQuicContext());
    }
}

