/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.handler.packet.RetryPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.quic.parser.packet.RetryPacketParser;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.RetryPacketPreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.RetryPacketSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

@XmlRootElement
public class RetryPacket
extends LongHeaderPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    protected ModifiableByteArray retryToken;
    @ModifiableVariableProperty
    protected ModifiableByteArray retryIntegrityTag;

    public RetryPacket() {
        super(QuicPacketType.RETRY_PACKET);
        this.setUnprotectedFlags((byte)-16);
    }

    public RetryPacket(byte flags) {
        super(QuicPacketType.RETRY_PACKET);
        this.setProtectedFlags(flags);
        this.setUnprotectedFlags(flags);
        this.protectedHeaderHelper.write((int)flags);
    }

    public boolean verifyRetryIntegrityTag(QuicContext context) {
        byte[] computedTag = QuicPacketCryptoComputations.calculateRetryIntegrityTag(context, this);
        boolean tagsEqual = Arrays.areEqual((byte[])((byte[])this.getRetryIntegrityTag().getValue()), (byte[])computedTag);
        LOGGER.debug("Retry Integrity Tag is valid? {}", (Object)tagsEqual);
        return tagsEqual;
    }

    public RetryPacketHandler getHandler(Context context) {
        return new RetryPacketHandler(context.getQuicContext());
    }

    public Serializer<RetryPacket> getSerializer(Context context) {
        return new RetryPacketSerializer(this);
    }

    public Preparator<RetryPacket> getPreparator(Context context) {
        return new RetryPacketPreparator(context.getChooser(), this);
    }

    public RetryPacketParser getParser(Context context, InputStream stream) {
        return new RetryPacketParser(stream, context.getQuicContext());
    }

    public ModifiableByteArray getRetryToken() {
        return this.retryToken;
    }

    public void setRetryToken(byte[] retryToken) {
        this.retryToken = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.retryToken, (byte[])retryToken);
    }

    public void setRetryToken(ModifiableByteArray retryToken) {
        this.retryToken = retryToken;
    }

    public ModifiableByteArray getRetryIntegrityTag() {
        return this.retryIntegrityTag;
    }

    public void setRetryIntegrityTag(byte[] retryIntegrityTag) {
        this.retryIntegrityTag = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.retryIntegrityTag, (byte[])retryIntegrityTag);
    }

    public void setRetryIntegrityTag(ModifiableByteArray retryIntegrityTag) {
        this.retryIntegrityTag = retryIntegrityTag;
    }
}

