/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionCloseFrameParser
extends QuicFrameParser<ConnectionCloseFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ConnectionCloseFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(ConnectionCloseFrame frame) {
        this.parseErrorCode(frame);
        if ((Long)frame.getFrameType().getValue() == 28L) {
            this.parseFrameType(frame);
        }
        this.parseReasonPhraseLength(frame);
        this.parseReasonPhrase(frame);
    }

    protected void parseErrorCode(ConnectionCloseFrame frame) {
        frame.setErrorCode((int)this.parseVariableLengthInteger());
        LOGGER.debug("Error Code: {}", frame.getErrorCode().getValue());
    }

    protected void parseFrameType(ConnectionCloseFrame frame) {
        frame.setTriggerFrameType((int)this.parseVariableLengthInteger());
        LOGGER.debug("Frame Type: {}", frame.getTriggerFrameType().getValue());
    }

    protected void parseReasonPhraseLength(ConnectionCloseFrame frame) {
        frame.setReasonPhraseLength((int)this.parseVariableLengthInteger());
        LOGGER.debug("Reason Phrase Length: {}", frame.getReasonPhraseLength().getValue());
    }

    protected void parseReasonPhrase(ConnectionCloseFrame frame) {
        frame.setReasonPhrase(this.parseByteArrayField(((Long)frame.getReasonPhraseLength().getValue()).intValue()));
        LOGGER.debug("Reason Phrase: {}", frame.getReasonPhrase().getValue());
    }
}

