/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.frame.CryptoFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoFrameParser
extends QuicFrameParser<CryptoFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CryptoFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(CryptoFrame frame) {
        this.parseOffset(frame);
        this.parseLength(frame);
        this.parseCryptoData(frame);
    }

    protected void parseOffset(CryptoFrame frame) {
        frame.setOffset((int)this.parseVariableLengthInteger());
        LOGGER.debug("Offset: {}", frame.getOffset().getValue());
    }

    protected void parseLength(CryptoFrame frame) {
        frame.setLength((int)this.parseVariableLengthInteger());
        LOGGER.debug("Length: {}", frame.getLength().getValue());
    }

    protected void parseCryptoData(CryptoFrame frame) {
        frame.setCryptoData(this.parseByteArrayField(((Long)frame.getLength().getValue()).intValue()));
        LOGGER.debug("Crypto Data: {}", frame.getCryptoData().getValue());
    }
}

