/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.DatagramFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagramFrameParser
extends QuicFrameParser<DatagramFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DatagramFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(DatagramFrame frame) {
        QuicFrameType frameType = QuicFrameType.getFrameType((Long)frame.getFrameType().getValue());
        if (frameType == QuicFrameType.DATAGRAM_FRAME_LEN) {
            this.parseLength(frame);
        }
        this.parseData(frame);
    }

    protected void parseLength(DatagramFrame frame) {
        frame.setLength((int)this.parseVariableLengthInteger());
        LOGGER.debug("Length: {}", frame.getLength().getValue());
    }

    protected void parseData(DatagramFrame frame) {
        if (frame.getLength() == null) {
            frame.setData(this.parseTillEnd());
        } else {
            frame.setData(this.parseByteArrayField((Integer)frame.getLength().getValue()));
        }
        LOGGER.debug("Data: {}", frame.getData().getValue());
    }
}

