/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.frame.NewConnectionIdFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewConnectionIdFrameParser
extends QuicFrameParser<NewConnectionIdFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewConnectionIdFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(NewConnectionIdFrame frame) {
        this.parseSequenceNumber(frame);
        this.parseRetirePriorTo(frame);
        this.parseConnectionIdLength(frame);
        this.parseConnectionId(frame);
        this.parseStatelessResetToken(frame);
    }

    protected void parseSequenceNumber(NewConnectionIdFrame frame) {
        frame.setSequenceNumber((int)this.parseVariableLengthInteger());
        LOGGER.debug("Sequence  Number: {}", frame.getSequenceNumber().getValue());
    }

    protected void parseRetirePriorTo(NewConnectionIdFrame frame) {
        frame.setRetirePriorTo((int)this.parseVariableLengthInteger());
        LOGGER.debug("Retire Prior To: {}", frame.getRetirePriorTo().getValue());
    }

    protected void parseConnectionIdLength(NewConnectionIdFrame frame) {
        frame.setConnectionIdLength(this.parseIntField(1));
        LOGGER.debug("Length: {}", frame.getConnectionIdLength().getValue());
    }

    protected void parseConnectionId(NewConnectionIdFrame frame) {
        frame.setConnectionId(this.parseByteArrayField((Integer)frame.getConnectionIdLength().getValue()));
        LOGGER.debug("Connection ID: {}", frame.getConnectionId().getValue());
    }

    protected void parseStatelessResetToken(NewConnectionIdFrame frame) {
        frame.setStatelessResetToken(this.parseByteArrayField(16));
        LOGGER.debug("Stateless Reset Token: {}", frame.getStatelessResetToken().getValue());
    }
}

