/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.packet;

import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.QuicPacketParser;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LongHeaderPacketParser<T extends LongHeaderPacket>
extends QuicPacketParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public LongHeaderPacketParser(InputStream stream, QuicContext context) {
        super(stream, context);
    }

    protected void parseSourceConnectionIdLength(T packet) {
        byte idLengthBytes = this.parseByteField(1);
        ((LongHeaderPacket)packet).setSourceConnectionIdLength(idLengthBytes);
        ((LongHeaderPacket)packet).protectedHeaderHelper.write((int)idLengthBytes);
        LOGGER.debug("Source Connection ID Length: {}", ((LongHeaderPacket)packet).getSourceConnectionIdLength().getValue());
    }

    protected void parseSourceConnectionId(T packet) {
        byte[] sourceIdBytes = this.parseByteArrayField((int)((Byte)((LongHeaderPacket)packet).getSourceConnectionIdLength().getValue() & 0xFF));
        ((LongHeaderPacket)packet).setSourceConnectionId(sourceIdBytes);
        ((LongHeaderPacket)packet).protectedHeaderHelper.write(sourceIdBytes);
        LOGGER.debug("Source Connection ID: {}", ((LongHeaderPacket)packet).getSourceConnectionId().getValue());
    }
}

