/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.packet;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuicPacketParser<T extends QuicPacket>
extends Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected QuicContext context;

    public QuicPacketParser(InputStream stream, QuicContext context) {
        super(stream);
        this.context = context;
    }

    protected void parseFlag(T packet) {
        byte firstHeaderByte = this.parseByteField(1);
        ((QuicPacket)packet).protectedHeaderHelper.write((int)firstHeaderByte);
        ((QuicPacket)packet).setProtectedFlags(firstHeaderByte);
        LOGGER.debug("Protected Flags: {}", ((QuicPacket)packet).getProtectedFlags().getValue());
    }

    protected void parseDestinationConnectionIdLength(T packet) {
        byte destinationConnectionIdBytes = this.parseByteField(1);
        ((QuicPacket)packet).protectedHeaderHelper.write((int)destinationConnectionIdBytes);
        ((QuicPacket)packet).setDestinationConnectionIdLength(destinationConnectionIdBytes);
        LOGGER.debug("Destination Connection ID Length: {}", ((QuicPacket)packet).getDestinationConnectionIdLength().getValue());
    }

    protected void parseDestinationConnectionId(T packet) {
        byte[] destinationConnectionIdLengthBytes = this.parseByteArrayField((int)((Byte)((QuicPacket)packet).getDestinationConnectionIdLength().getValue() & 0xFF));
        ((QuicPacket)packet).setDestinationConnectionId(destinationConnectionIdLengthBytes);
        ((QuicPacket)packet).protectedHeaderHelper.write(destinationConnectionIdLengthBytes);
        LOGGER.debug("Destination Connection ID: {}", ((QuicPacket)packet).getDestinationConnectionId().getValue());
    }

    protected void parsePacketLength(T packet) {
        try {
            int before = this.getStream().available();
            int result = (int)this.parseVariableLengthInteger();
            int after = this.getStream().available();
            ((QuicPacket)packet).protectedHeaderHelper.write(this.quicBuffer.toByteArray());
            this.quicBuffer.reset();
            ((QuicPacket)packet).setPacketLength(result);
            ((QuicPacket)packet).setPacketLengthSize(before - after);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug("Packet Length: {}", ((QuicPacket)packet).getPacketLength().getValue());
    }

    protected void parseProtectedPacketNumberAndPayload(T packet) {
        byte[] r = this.parseByteArrayField((Integer)((QuicPacket)packet).getPacketLength().getValue());
        ((QuicPacket)packet).setProtectedPacketNumberAndPayload(r);
        LOGGER.debug("Protected Packet Number And Payload: {}", ((QuicPacket)packet).getProtectedPacketNumberAndPayload().getValue());
    }

    public void parseUnprotectedPacketNumberLength(T packet) {
        byte unprotectedFlags = (Byte)((QuicPacket)packet).getUnprotectedFlags().getValue();
        int length = (unprotectedFlags & 3) + 1;
        ((QuicPacket)packet).setPacketNumberLength(length);
        LOGGER.debug("Packet Number Length: {}", ((QuicPacket)packet).getPacketNumberLength().getValue());
    }

    public void parseProtectedPacketNumber(T packet) {
        int length = (Integer)((QuicPacket)packet).getPacketNumberLength().getValue();
        byte[] packetNumber = new byte[length];
        System.arraycopy(((QuicPacket)packet).getProtectedPacketNumberAndPayload().getValue(), 0, packetNumber, 0, length);
        ((QuicPacket)packet).setProtectedPacketNumber(packetNumber);
        LOGGER.debug("Protected Packet Number: {}", ((QuicPacket)packet).getProtectedPacketNumber().getValue());
    }
}

