/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.packet.HandshakePacket;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.LongHeaderPacketPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandshakePacketPreparator
extends LongHeaderPacketPreparator<HandshakePacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HandshakePacketPreparator(Chooser chooser, HandshakePacket packet) {
        super(chooser, packet);
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing Handshake Packet");
        this.prepareUnprotectedPacketNumber();
        this.preparePacketNumberLength();
        this.prepareUnprotectedFlags();
        this.prepareLongHeaderPacket();
    }

    private void prepareUnprotectedPacketNumber() {
        if (((HandshakePacket)this.packet).getUnprotectedPacketNumber() == null) {
            ((HandshakePacket)this.packet).setUnprotectedPacketNumber(this.context.getHandshakePacketPacketNumber());
            this.context.setHandshakePacketPacketNumber(this.context.getHandshakePacketPacketNumber() + 1);
            LOGGER.debug("Unprotected Packet Number: {}", ((HandshakePacket)this.packet).getUnprotectedPacketNumber().getValue());
        }
    }

    private void prepareUnprotectedFlags() {
        byte packetType = QuicPacketType.HANDSHAKE_PACKET.getHeader(this.context.getQuicVersion());
        int packetNumber = (Integer)((HandshakePacket)this.packet).getPacketNumberLength().getValue();
        ((HandshakePacket)this.packet).setUnprotectedFlags((byte)(packetType ^ packetNumber - 1));
        LOGGER.debug("Unprotected Flags: {}", ((HandshakePacket)this.packet).getUnprotectedFlags().getValue());
    }
}

