/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.LongHeaderPacketPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialPacketPreparator
extends LongHeaderPacketPreparator<InitialPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public InitialPacketPreparator(Chooser chooser, InitialPacket packet) {
        super(chooser, packet);
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing Initial Packet");
        this.prepareUnprotectedPacketNumber();
        this.preparePacketNumberLength();
        this.prepareUnprotectedFlags();
        this.prepareToken();
        this.prepareLongHeaderPacket();
    }

    private void prepareToken() {
        if (this.context.getInitialPacketToken() != null) {
            ((InitialPacket)this.packet).setToken(this.context.getInitialPacketToken());
            ((InitialPacket)this.packet).setTokenLength(this.context.getInitialPacketToken().length);
        } else {
            ((InitialPacket)this.packet).setToken(new byte[0]);
            ((InitialPacket)this.packet).setTokenLength(0);
        }
        LOGGER.debug("Token: {}", ((InitialPacket)this.packet).getToken().getValue());
        LOGGER.debug("Token Length: {}", (Object)((InitialPacket)this.packet).getTokenLength());
    }

    private void prepareUnprotectedPacketNumber() {
        if (((InitialPacket)this.packet).getUnprotectedPacketNumber() == null) {
            ((InitialPacket)this.packet).setUnprotectedPacketNumber(this.context.getInitialPacketPacketNumber());
            this.context.setInitialPacketPacketNumber(this.context.getInitialPacketPacketNumber() + 1);
            LOGGER.debug("Unprotected Packet Number: {}", ((InitialPacket)this.packet).getUnprotectedPacketNumber().getValue());
        }
    }

    private void prepareUnprotectedFlags() {
        byte packetType = QuicPacketType.INITIAL_PACKET.getHeader(this.context.getQuicVersion());
        int packetNumber = (Integer)((InitialPacket)this.packet).getPacketNumberLength().getValue();
        ((InitialPacket)this.packet).setUnprotectedFlags((byte)(packetType ^ packetNumber - 1));
        LOGGER.debug("Unprotected Flags: {}", ((InitialPacket)this.packet).getUnprotectedFlags().getValue());
    }

    @Override
    protected int calculatePadding() {
        if (this.context.getConfig().isQuicDoNotPad().booleanValue()) {
            return 0;
        }
        if (((InitialPacket)this.packet).getConfiguredPadding() > -1) {
            return ((InitialPacket)this.packet).getConfiguredPadding();
        }
        return Math.max(0, 1200 - (6 + this.context.getDestinationConnectionId().length + 1 + this.context.getSourceConnectionId().length + (((byte[])((InitialPacket)this.packet).getToken().getValue()).length == 0 ? 1 : (Integer)((InitialPacket)this.packet).getTokenLength().getValue() + ((InitialPacket)this.packet).getTokenLengthSize()) + 2 + (Integer)((InitialPacket)this.packet).getPacketNumberLength().getValue() + ((byte[])((InitialPacket)this.packet).getUnprotectedPayload().getValue()).length + 16));
    }
}

