/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.QuicPacketPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LongHeaderPacketPreparator<T extends LongHeaderPacket>
extends QuicPacketPreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public LongHeaderPacketPreparator(Chooser chooser, T packet) {
        super(chooser, packet);
    }

    protected void prepareLongHeaderPacket() {
        this.prepareQuicVersion();
        this.prepareSourceConnectionId();
        this.prepareSourceConnectionIdLength();
        this.prepareQuicPacket();
    }

    protected void prepareSourceConnectionIdLength() {
        ((LongHeaderPacket)this.packet).setSourceConnectionIdLength((byte)((byte[])((LongHeaderPacket)this.packet).getSourceConnectionId().getValue()).length);
        LOGGER.debug("Source Connection ID Length: {}", ((LongHeaderPacket)this.packet).getSourceConnectionIdLength().getValue());
    }

    protected void prepareSourceConnectionId() {
        ((LongHeaderPacket)this.packet).setSourceConnectionId(this.context.getSourceConnectionId());
        LOGGER.debug("Source Connection ID: {}", ((LongHeaderPacket)this.packet).getSourceConnectionId().getValue());
    }

    public void prepareQuicVersion() {
        ((LongHeaderPacket)this.packet).setQuicVersion(this.context.getQuicVersion());
        LOGGER.debug("Quic Version: {}", ((LongHeaderPacket)this.packet).getQuicVersion().getValue());
    }
}

