/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.quic.packet.RetryPacket;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.LongHeaderPacketPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryPacketPreparator
extends LongHeaderPacketPreparator<RetryPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RetryPacketPreparator(Chooser chooser, RetryPacket packet) {
        super(chooser, packet);
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing Retry Packet");
        this.prepareUnprotectedFlags();
        this.prepareRetryToken();
        ((RetryPacket)this.packet).setUnprotectedPacketNumber(0);
        ((RetryPacket)this.packet).setUnprotectedPayload(new byte[0]);
        this.prepareLongHeaderPacket();
        this.prepareRetryIntegrityTag();
    }

    private void prepareRetryToken() {
        ((RetryPacket)this.packet).setRetryToken(this.context.getConfig().getDefaultQuicServerRetryToken());
        LOGGER.debug("Token: {}", ((RetryPacket)this.packet).getRetryToken().getValue());
    }

    private void prepareUnprotectedFlags() {
        ((RetryPacket)this.packet).setUnprotectedFlags(QuicPacketType.RETRY_PACKET.getHeader(this.context.getQuicVersion()));
        LOGGER.debug("Unprotected Flags: {}", ((RetryPacket)this.packet).getUnprotectedFlags().getValue());
    }

    private void prepareRetryIntegrityTag() {
        byte[] tag = QuicPacketCryptoComputations.calculateRetryIntegrityTag(this.context, (RetryPacket)this.packet);
        ((RetryPacket)this.packet).setRetryIntegrityTag(tag);
    }
}

